/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */
/*global $, document, transferKeyMessage, dismissInAppWalkthroughWindow, logDWMessage, logIsCCUser, updateSlide*/
var NFW_HEADLIGHTS = {
    UT_NFW : "NFW",
    UT_NFW_CC : "NFW_CC User clicked",
    UT_NFW_PRECC : "NFW_Pre CC User clicked",
    UT_NFW_SKIP : "NFW_User skipped tour",
    UT_NFW_VIDEO : "NFW_Video Watched ",
    UT_OTH_NFW : "OTH_NFW",
    UT_OTH_NFW_TOUR_ENDED : "OTH_NFW_Tour ended on slide ",
    UT_OTH_NFW_ALL_WALKEDBY : "OTH_NFW_All slides walked by",
    UT_OTH_NFW_PREVIOUS_SLIDE : "OTH_NFW_Navigated to previous slide",
    UT_OTH_NFW_ALL_VIDEOS_WATCHED : "OTH_NFW_All Videos Watched"
};

var Manager = (function () {
    "use strict";
    var isCC = false;
    var navCounter = 0;
    var KEYCODE_ESC = 27;
    var KEYCODE_RIGHT = 39;
    var KEYCODE_LEFT = 37;
	var KEYCODE_BACKSPACE = 8;
    return {
        setIsCC: function (isCCFlag) { isCC = isCCFlag; window.name = isCCFlag; },
        getIsCC: function () { return isCC; },
        setNavCounter: function (newCounter) { navCounter = newCounter; },
        getNavCounter: function () { return navCounter; },
        incNavCounter: function () { ++navCounter; },
        decNavCounter: function () { --navCounter; },
        getAsciiFromDroverKeyCode: function (droverKeyCode) {
            var DROVER_KEYCODE_LEFT = 42;
            var DROVER_KEYCODE_RIGHT = 43;
            var asciiKeyCode;
            switch (droverKeyCode) {
            case DROVER_KEYCODE_LEFT:
                asciiKeyCode = KEYCODE_LEFT;
                break;
            case DROVER_KEYCODE_RIGHT:
                asciiKeyCode = KEYCODE_RIGHT;
                break;
            default:
                break;
            }
            return asciiKeyCode;
        },
		preventNavigationIfNeeded: function (event) {
			if (event.keyCode === KEYCODE_BACKSPACE) {
				event.preventDefault();
				return false;
			}
		},
        handleKeyupEvent: function (event) {
            //If Escape is pressed pass call the transferKeyMessage function
            var pageIndex = 0;
            var PREFIX = "page";
            var PLACEHOLDER_CLASS = ".placeholder";
            if (!Manager.getIsCC()) {
                PREFIX += "_new";
                PLACEHOLDER_CLASS += "_new";
            }
            var CLASS_PREFIX = "." + PREFIX;
            switch (event.keyCode) {
            case KEYCODE_ESC:
                if (navCounter === 0) {
                    logDWMessage(NFW_HEADLIGHTS.UT_NFW, NFW_HEADLIGHTS.UT_NFW_SKIP);
                } else if ((isCC === true) && (navCounter <= 3)) {
                    logDWMessage(NFW_HEADLIGHTS.UT_OTH_NFW, NFW_HEADLIGHTS.UT_OTH_NFW_TOUR_ENDED + navCounter);
                } else if ((isCC === false) && (navCounter <= 5)) {
                    logDWMessage(NFW_HEADLIGHTS.UT_OTH_NFW, NFW_HEADLIGHTS.UT_OTH_NFW_TOUR_ENDED + navCounter);
                }
                transferKeyMessage(event.keyCode);
                break;
            case KEYCODE_RIGHT:
                pageIndex = navCounter;
                if (pageIndex > $(CLASS_PREFIX).length - 3 || pageIndex <= 0) {
                    return;
                }
                forward(null, false, pageIndex);
                break;
            case KEYCODE_LEFT:
                pageIndex = navCounter;
                if (pageIndex > $(CLASS_PREFIX).length - 2 || pageIndex <= 0) {
                    return;
                }
                forward(null, true, pageIndex);
                break;
            default:
                break;
            }
        }
    };
}());
function navMessageFromDw(keyCode) {
    "use strict";
    var event = {};
    event.keyCode = Manager.getAsciiFromDroverKeyCode(keyCode);
    Manager.handleKeyupEvent(event);
}
function showVideoGallery(page) {
    "use strict";
    var PREFIX = ".page";
    if (window.name) {
        Manager.setIsCC(window.name === "true");
    }
    if (!Manager.getIsCC()) {
        PREFIX += "_new";
    }
    var pageIndex = $(PREFIX).index($("#" + page));
    Manager.setNavCounter(pageIndex);
    $("#page0").css({display: "none"});
    $("#" + page).css({display: "block", opacity: 1});
}

function initStrings() {
    "use strict";
    $.i18n.properties({
        name: 'NfwOriginalStrings',
        language: ' ',
        path: 'strings/',
        mode: 'both',
        callback: function () {
            var locItems = $(".ToTranslate");
            var j = 0;
            for (j = 0; j < locItems.length; j++) {
                var nKey = locItems[j].getAttribute("data-id");
                locItems[j].innerHTML = jQuery.i18n.prop(nKey);
            }
        }
    });
}

function initUI(userName, stage, ccCheck) {
    "use strict";
    var url = window.location.href;
    var index = 0;
    var USER_NAME_CLASS = ".userName";
    var arr = url.split("#");
    
    document.addEventListener("keydown", Manager.preventNavigationIfNeeded, true);
    document.addEventListener("keyup", Manager.handleKeyupEvent);
    //If we have been supplied a user name, put it in the document
    if (userName) {
        var matches = document.querySelectorAll(USER_NAME_CLASS);
        for (index = 0; index < matches.length; ++index) {
            matches[index].innerHTML = ", " + userName;
        }
    }
    
    initStrings();
    if (stage) {
        //ccCheck = 1 for CC user(yep), = 0 for CS6(nope)    
        Manager.setIsCC(ccCheck);
        forward(null, false, 0, stage);
    }
    
    if (arr.length === 2) {
        showVideoGallery(arr[1]);
        return;
    }
}
function getConnectionStatus(isConnected) {
    "use strict";
    if (isConnected) {
        $(".internetMessage").css({ display: "none" });
    }
}
function forward(event, isBackward, inPageIndex, stage) {
    "use strict";
    var PREFIX = "page";
    var PREFIX_OLD = "page";
    var PLACEHOLDER_CLASS = ".placeholder";
    if ((isBackward === true) && (Manager.getNavCounter() === 1) && (!Manager.getIsCC())) {
        PREFIX_OLD += "_new";
    } else if (!Manager.getIsCC()) {
        PREFIX += "_new";
        PLACEHOLDER_CLASS += "_new";
        PREFIX_OLD += "_new";
    }

    var classPrefix = "." + PREFIX;
    var idPrefix = "#" + PREFIX;
    var classPrefixOld = "." + PREFIX_OLD;
    
    var pageIndex = 0;
    if (!stage) {
        pageIndex = inPageIndex || $(classPrefixOld).index($(event.target).closest(classPrefixOld));
    }

    if (pageIndex > $(classPrefixOld).length - 1 || pageIndex < 0) {
        return;
    }
    var pageObj = $(classPrefixOld)[pageIndex];
    var delayFade = 50;
    var delayTrans = 500;
    var nextSlide = 1;
    if (isBackward) {
        logDWMessage(NFW_HEADLIGHTS.UT_OTH_NFW, NFW_HEADLIGHTS.UT_OTH_NFW_PREVIOUS_SLIDE);
        nextSlide = -1;
        Manager.decNavCounter();
    } else {
        Manager.incNavCounter();
    }
    if (Manager.getNavCounter() === 0) {
        updateSlide(0);
    } else if (((Manager.getIsCC() === true) && (Manager.getNavCounter() <= 3)) || ((Manager.getIsCC() === false) && (Manager.getNavCounter() <= 5))) {
        updateSlide(Manager.getNavCounter());
    } else {
        updateSlide(-1);
    }
    $(pageObj).animate({
        opacity: 0
    }, delayFade, function () {
        var ANIMATION_ID = "#animation";
        var IMG_URL_ATTRIBUTE = 'data-img';
        $($(PLACEHOLDER_CLASS)[isBackward ? pageIndex - 2 : pageIndex]).css({ marginBottom: '200px' });
        $(pageObj).css({ display: 'none' });
        // Animation complete.
        var idToBeAnimated = idPrefix + (nextSlide + pageIndex);
        if (pageIndex === $(classPrefix).length - 3 && !isBackward) {
            idToBeAnimated = "#page_gallery";
            logDWMessage(NFW_HEADLIGHTS.UT_OTH_NFW, NFW_HEADLIGHTS.UT_OTH_NFW_ALL_WALKEDBY);
        } else if (pageIndex === $(classPrefix).length - 1 && isBackward) {
            idToBeAnimated = idPrefix + (nextSlide + pageIndex);
        }

        //Having multiple GIFs playing in the background makes CEF come to a crawl. So we
        //remove the animated GIF in the current page and insert the GIF for the page to be shown if necessary
        $("#" + $(pageObj).attr("id") + " " + ANIMATION_ID).remove();
        var imgURL = $(idToBeAnimated).attr(IMG_URL_ATTRIBUTE);
        //Add the timestamp to the URL so that the browser reloads the image every time
        var d = new Date();
        if (imgURL && imgURL !== "") {
            $('<img id="animation" src="' + imgURL + '?nocache=' + d.getTime() + '">').insertAfter(idToBeAnimated + " " + PLACEHOLDER_CLASS);
        }
        $(idToBeAnimated).css({ display: 'block' });
        $(idToBeAnimated).animate({
            opacity: 1
        }, delayFade);
        $($(PLACEHOLDER_CLASS)[isBackward ? pageIndex - 2 : pageIndex]).animate({ marginBottom: 0 }, delayTrans);
    });
}
var chooseVersion = function (event) {
    "use strict";
    var isCC = $(event.target).prop("id") === "dreamweaverCC";
    if (isCC) {
        logDWMessage(NFW_HEADLIGHTS.UT_NFW, NFW_HEADLIGHTS.UT_NFW_CC);
        logIsCCUser(true);
    } else {
        logDWMessage(NFW_HEADLIGHTS.UT_NFW, NFW_HEADLIGHTS.UT_NFW_PRECC);
        logIsCCUser(false);
    }
    console.log(event.target);
    Manager.setIsCC(isCC);
    forward(event);
};
var chooseDirection = function (event) {
    "use strict";
    forward(event, $(event.target).hasClass("backNavButton"));
};

var navFromGallery = function (event) {
    "use strict";
    forward(event, $(event.target).hasClass("backButton"));
};
var playVideo = function (event) {
	"use strict";
    var THUMBNAIL_CLASS = ".thumbnailContainer";
    var videoTag = $(event.target).attr('data-headlights');
    logDWMessage(NFW_HEADLIGHTS.UT_NFW, NFW_HEADLIGHTS.UT_NFW_VIDEO + videoTag);
    
    var videoURL = $(event.target).attr('data-url');
	$("#page_gallery").css({display: "none"});
	$("#player_screen").css({display: "block", opacity: 1});
	$('<iframe src="' + videoURL + '" width="620" height="480" frameborder="0" id="player" allowfullscreen></iframe>').insertBefore("#playerFooter");
    Manager.incNavCounter();
};

var stopAndDismissWindow = function () {
	"use strict";
	$("#player").remove();
	dismissInAppWalkthroughWindow();
};

var dismissWindow = function () {
    "use strict";
    if (Manager.getNavCounter() === 0) {
        logDWMessage(NFW_HEADLIGHTS.UT_NFW, NFW_HEADLIGHTS.UT_NFW_SKIP);
    } else if ((Manager.getIsCC() === true) && (Manager.getNavCounter() <= 3)) {
        logDWMessage(NFW_HEADLIGHTS.UT_OTH_NFW, NFW_HEADLIGHTS.UT_OTH_NFW_TOUR_ENDED + Manager.getNavCounter());
    } else if ((Manager.getIsCC() === false) && (Manager.getNavCounter() <= 5)) {
        logDWMessage(NFW_HEADLIGHTS.UT_OTH_NFW, NFW_HEADLIGHTS.UT_OTH_NFW_TOUR_ENDED + Manager.getNavCounter());
    }
    dismissInAppWalkthroughWindow();
};

var navFromPlayer = function () {
	"use strict";
	$("#player").remove();
	$("#player_screen").css({display: "none"});
	$("#page_gallery").css({display: "block", opacity: 1});
    Manager.decNavCounter();
};


$(".navButton").click(chooseDirection);
$(".versionChoiceButton").click(chooseVersion);
$(".exitChoiceButton").click(navFromPlayer);
$(".galleryButton").click(navFromGallery);
$(".playButton").click(playVideo);
